<?php
session_start();
include "conn.php";

// In a real setup, you’d check if the admin is logged in
// e.g., if (!isset($_SESSION['admin_logged_in'])) die("Access denied.");
?>
<!DOCTYPE html>
<html>
<head>
<title>Admin Chat Panel</title>
<style>
body { font-family: Arial; background:#f4f6f8; margin:20px; }
.container { display:flex; gap:20px; }
.user-list { width:220px; background:#fff; border-radius:10px; padding:10px; box-shadow:0 2px 5px rgba(0,0,0,0.1); overflow-y:auto; height:450px; }
.chat-box { flex:1; background:#fff; border-radius:10px; padding:15px; box-shadow:0 2px 5px rgba(0,0,0,0.1); }
.message { margin:8px 0; padding:8px 10px; border-radius:10px; max-width:70%; }
.user { background:#69a8cc; color:white; margin-left:auto; text-align:right; }
.admin { background:#eee; color:#333; margin-right:auto; }
.chat-messages { height:400px; overflow-y:auto; background:#f9fafc; padding:10px; border-radius:10px; }
form { display:flex; padding:10px 0; }
input[type=text] { flex:1; padding:10px; border:1px solid #ccc; border-radius:8px; }
button { margin-left:10px; background:#69a8cc; color:white; border:none; padding:10px 20px; border-radius:8px; cursor:pointer; }
</style>
</head>
<body>
<h2>Admin Chat Panel</h2>
<div class="container">
  <div class="user-list">
    <h4>Users</h4>
    <?php
      $users = $conn->query("SELECT DISTINCT user_phone FROM chat_messages ORDER BY user_phone ASC");
      while ($u = $users->fetch_assoc()):
    ?>
      <div><a href="?user=<?php echo urlencode($u['user_phone']); ?>">📱 <?php echo htmlspecialchars($u['user_phone']); ?></a></div>
    <?php endwhile; ?>
  </div>

  <div class="chat-box">
    <?php if (isset($_GET['user'])): 
      $phone = $_GET['user'];
    ?>
    <div id="messages" class="chat-messages"></div>

    <form id="adminForm">
      <input type="hidden" name="user_phone" value="<?php echo htmlspecialchars($phone); ?>">
      <input type="text" name="message" id="adminMsg" placeholder="Type message..." required>
      <button type="submit">Send</button>
    </form>

    <script>
    const msgDiv = document.getElementById('messages');
    const form = document.getElementById('adminForm');
    const msgInput = document.getElementById('adminMsg');

    function loadMsgs(){
      fetch('get_message.php?user_phone=<?php echo urlencode($phone); ?>')
      .then(res => res.text())
      .then(html => { msgDiv.innerHTML = html; msgDiv.scrollTop = msgDiv.scrollHeight; });
    }

    form.addEventListener('submit', e => {
      e.preventDefault();
      const data = new FormData(form);
      fetch('send_admin_message.php', { method: 'POST', body: data })
      .then(() => { msgInput.value=''; loadMsgs(); });
    });

    setInterval(loadMsgs, 3000);
    loadMsgs();
    </script>
    <?php else: ?>
      <p>Select a user to chat with.</p>
    <?php endif; ?>
  </div>
</div>
</body>
</html>