<?php
header('Content-Type: application/json');

// Include the database connection
include 'conn.php';

// Get the input data from the AJAX request
$input = json_decode(file_get_contents('php://input'), true);
$itemName = $input['itemName'];

// Query the database for the item's status
$sql = "SELECT status FROM items WHERE name = ?";
$stmt = $conn->prepare($sql);

if ($stmt) {
    $stmt->bind_param("s", $itemName);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo json_encode(['status' => $row['status']]); // Return the status
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Item not found']);
    }

    $stmt->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Database query failed']);
}

$conn->close();
?>