<?php
include 'conn.php';
$error_message = '';
$user_details = null;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Retrieve form data
    $phone = $_POST['phone'];
    $password = $_POST['password'];

    // SQL query to check credentials
    $sql = "SELECT * FROM user WHERE phone = ? AND password = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $phone, $password);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Credentials are correct, fetch user details
        $user_details = $result->fetch_assoc();

        // Set local storage values in JavaScript
        echo "<script>
            localStorage.setItem('phone', '" . $user_details['phone'] . "');
            localStorage.setItem('name', '" . $user_details['name'] . "');
            localStorage.setItem('location', '" . $user_details['location'] . "');
            window.location.href = 'hometest.php'; // Redirect to the next page
        </script>";
    } else {
        $error_message = "One of your credentials is invalid please try again...";
    }

    $stmt->close();
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vetline Services - Delivery Portal</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');

        body {
            font-family: 'Roboto', sans-serif;
            color: #2e7d32;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            animation: backgroundAnimation 10s ease infinite;
        }
        
        .container {
            background-color: #ffffff;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            padding: 20px;
            text-align: center;
            width: 80%;
            max-width: 400px;
            animation: fadeIn 2s ease-in-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        h1 {
            color: #04837f;
            margin-bottom: 20px;
        }

        form {
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        label {
            font-weight: bold;
            margin-top: 10px;
        }

        input[type="text"], input[type="password"] {
            width: 100%;
            padding: 10px;
            margin: 5px 0 10px;
            border: 1px solid #c8e6c9;
            border-radius: 5px;
            background-color: #f1f8e9;
            color: #2e7d32;
        }

        button {
            background-color: yellow;
            color: black;
            border: none;
            padding: 10px 20px;
            border-radius: 35px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.5s ease;
            margin-top: 20px;
        }

        button:hover {
            background-color:white;
            color:white;
        }

        .error {
            color: red;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
<center>
    <img src="img/logo/merlogo.png" alt="Logo" style="width:30%; border-radius:8px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);">
</center>
        <?php if ($user_details): ?>
            <h1>Hi, <?php echo htmlspecialchars($user_details['name']); ?>!</h1>
            <form action="home.php" method="post">
                <span style="display:none;">
     
                    <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($user_details['name']); ?>" readonly><br><br>
                    <input type="text" id="phone" name="phone" value="<?php echo htmlspecialchars($user_details['phone']); ?>" readonly><br><br>
                 <input type="text" id="location" name="location" value="<?php echo htmlspecialchars($user_details['location']); ?>" readonly><br><br>

                </span>            
                <!-- Add more user details as needed -->
                <button type="submit">ORDER NOW</button>
            </form>
        <?php else: ?>
            <form method="post" action="signin.html" style="max-width: 400px; margin: auto; padding: 2em; background: #fff; border-radius: 10px; box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);">
       
                <input type="hidden" id="phone" name="phone" required style="width: 100%; padding: 0.5em; margin-bottom: 1.5em; border: 1px solid #ccc; border-radius: 5px;" placeholder="Phone Number">
                <input type="hidden" id="password" name="password" required style="width: 100%; padding: 0.5em; margin-bottom: 1.5em; border: 1px solid #ccc; border-radius: 5px;" placeholder="Password">
        
                <button type="submit">TRY AGAIN</button>
                <?php if ($error_message): ?>
                    <div class="error"><?php echo htmlspecialchars($error_message); ?></div>
                <?php endif; ?>
            </form>
        <?php endif; ?>
    </div>
</body>
</html>