<?php
include 'conn.php';

$name = $_POST['name'] ?? '';
$phone = $_POST['phone'] ?? '';
$location = $_POST['location'] ?? '';
$branch = $_POST['branch'] ?? '';

$sql = "SELECT * FROM user WHERE name=? AND phone=? AND location=? AND branch=? LIMIT 1";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ssss", $name, $phone, $location, $branch);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0):
    $user = $result->fetch_assoc();

    $locationsResult = $conn->query("SELECT DISTINCT location FROM locations");
    $locations = $locationsResult->fetch_all(MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo htmlspecialchars($user['name']); ?>'s Profile</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

    <style>
        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: 'Quicksand', sans-serif;
            background:;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
            min-height: 100vh;
        }

        .profile-card {
            background: #fff;
            padding: 32px 24px;
            border-radius: 24px;
            box-shadow: 0 16px 40px rgba(0,0,0,0.15);
            width: 100%;
            max-width: 420px;
            text-align: center;
        }

        .avatar {
            width: 110px;
            height: 110px;
            border-radius: 50%;
            object-fit: cover;
            margin-bottom: 16px;
            border: 5px solid #ffa726;
        }

        h2 {
            font-size: 24px;
            color: #333;
            margin-bottom: 10px;
        }

        form {
            text-align: left;
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            font-weight: 600;
            color: #444;
            font-size: 14px;
            display: block;
            margin-bottom: 6px;
        }

        input[type="text"], select, .cool-input {
            width: 100%;
            padding: 12px 14px;
            border: 2px solid #eee;
            border-radius: 12px;
            font-size: 15px;
            background-color: #fff;
            transition: all 0.3s ease;
        }

        input:focus, select:focus, .cool-input:focus {
            border-color: #ff7043;
            box-shadow: 0 0 6px rgba(255,112,67,0.3);
            outline: none;
        }

        .submit-btn {
            width: 100%;
            background-color: #ff7043;
            color: white;
            padding: 14px;
            font-size: 16px;
            border: none;
            border-radius: 12px;
            cursor: pointer;
            font-weight: 600;
            transition: background-color 0.3s;
        }

        .submit-btn:hover {
            background-color: #f4511e;
        }

        .icon-heading {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            margin-bottom: 20px;
            color: #ff7043;
        }

        .icon-heading i {
            font-size: 20px;
        }

        @media (max-width: 480px) {
            .profile-card {
                padding: 26px 18px;
            }
            h2 {
                font-size: 20px;
            }
        }
    </style>
</head>
<body>

<div class="profile-card">

 <form class="" style="padding-left:20px; display:;" id="orderForm" action="home.php" method="post">
   <input style="display:none;" type="text" id="item" name="name" value="<?php echo $_POST['name']; ?>">
    <input style="display:none;" type="text" name="phone" value="<?php echo $_POST['phone']; ?>">
   <input style="display:none;" type="text" name="location" value="<?php echo $_POST['location']; ?>"> 
      <input style="display:none;" type="text" name="branch" value="<?php echo $_POST['branch']; ?>"> 
  
<button type="submit" class="circle-button">
°•<i class="fas fa-home"></i>
</button>
<style>
.circle-button {
  background-color: yellow;
  color: black;
  width: 65px;
  height: 65px;
  border: none;
  border-radius: 50%;
  font-size: 16px;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  position: relative;
  box-shadow:
    0 8px 15px rgba(0, 0, 0, 0.2),  /* Outer shadow */
    inset 0 0 0 3px white,
    inset 0 0 0 6px yellow;
  transition: all 0.3s ease;
  transform: translateY(-3px); /* Slight lift to float */
  z-index: 10;
}

.circle-button:hover {
  transform: translateY(-6px); /* Lift more on hover */
  box-shadow:
    0 12px 20px rgba(0, 0, 0, 0.3),
    inset 0 0 0 3px white,
    inset 0 0 0 6px yellow;
}

@keyframes shake {
  0%, 100% { transform: translateX(0); }
  10%, 30%, 50%, 70%, 90% { transform: translateX(-10px); }
  20%, 40%, 60%, 80% { transform: translateX(10px); }
}

.skip {
  animation: bounce 0.5s;
}
</style>
<script>
document.getElementById('bagButton').addEventListener('click', function() {
  this.classList.add('skip');
  setTimeout(() => this.classList.remove('skip'), 500);
});
document.getElementById('userButton').addEventListener('click', function() {
  this.classList.add('skip');
  setTimeout(() => this.classList.remove('skip'), 500);
});
</script>

</form>   
 <br>	  
  
    <img src="https://ui-avatars.com/api/?name=<?php echo urlencode($user['name']); ?>&background=FF7043&color=fff&rounded=true&size=100"
         alt="Profile Picture" class="avatar">

    <div class="icon-heading">
      
        <h2><?php echo htmlspecialchars($user['name']); ?>'s Profile</h2>
    </div>

<form method="post" action="update_user.php">
    <input type="hidden" name="id" value="<?php echo $user['id']; ?>">

    <div class="form-group" style="position: relative;">
        <label>Name</label>
        <input type="text" name="name" value="<?php echo htmlspecialchars($user['name']); ?>" required>
        <i class="fas fa-pen edit-icon"></i>

        <input type="hidden" name="password" value="<?php echo htmlspecialchars($user['password']); ?>" required>   
        <input type="hidden" name="email" value="<?php echo htmlspecialchars($user['email']); ?>" required>       
    </div>

    <div class="form-group" style="position: relative;">
        <label>Phone</label>
        <input type="text" name="phone" value="<?php echo htmlspecialchars($user['phone']); ?>" required>
        <i class="fas fa-pen edit-icon"></i>
    </div>

    <div class="form-group" style="position: relative;">
        <label>Location</label>
        <input 
            type="text" 
            name="location" 
            id="locationInput"
            list="locationList"
            class="cool-input"
            placeholder="Start typing your location..."
            value="<?php echo htmlspecialchars($user['location']); ?>" 
            required>
        <i class="fas fa-pen edit-icon"></i>

        <datalist id="locationList">
            <?php foreach ($locations as $loc): ?>
                <option value="<?php echo htmlspecialchars($loc['location']); ?>"></option>
            <?php endforeach; ?>
        </datalist>
    </div>

    <div class="form-group" style="position: relative;">
        <label>Branch</label>
        <select name="branch" id="branchSelect" required>
            <option value="<?php echo $user['branch']; ?>"><?php echo $user['branch']; ?></option>
        </select>

    </div>

    <button type="submit" class="submit-btn">
        <i class="fas fa-save" style="margin-right: 8px;"></i>Update Profile
    </button>
</form>

<style>
.edit-icon {
    position: absolute;
    right: 10px;
    top: 34px;
    color: #aaa;
    cursor: pointer;
    font-size: 14px;
}
input:focus + .edit-icon,
select:focus + .edit-icon {
    color: #000;
}
</style>

      <hr>
<br><br>
      <span><a href="deactivate.html" style="color:red; font-size:11px; text-decoration:none;">🗑️ Delete My Account</a></span>

</div>

<script>
document.getElementById('locationInput').addEventListener('input', function() {
    const location = this.value.trim();
    const branchSelect = document.getElementById('branchSelect');

    if (location === '') {
        branchSelect.innerHTML = '<option value="">-- Select Branch --</option>';
        return;
    }

    fetch('get_branches.php?location=' + encodeURIComponent(location))
        .then(response => response.json())
        .then(data => {
            branchSelect.innerHTML = '';
            if (data.length === 0) {
                branchSelect.innerHTML = '<option value="">No branches found</option>';
                return;
            }
            data.forEach(branch => {
                const opt = document.createElement('option');
                opt.value = branch;
                opt.textContent = branch;
                branchSelect.appendChild(opt);
            });
        })
        .catch(err => {
            console.error('Failed to load branches', err);
            branchSelect.innerHTML = '<option value="">Error loading branches</option>';
        });
});
</script>
</body>
</html>

<?php
else:
    header("Location: signin.html");
    exit();
endif;

$conn->close();
?>