<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Your Order | Middle East Restaurant</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="author" content="Cemre Tellioğlu Tunçay">

    <link href="https://fonts.googleapis.com/css?family=Poppins:300,400,600,800&display=swap" rel="stylesheet">
    
    <link rel="icon" type="image/png" href="merlogo.png" sizes="32x32" />
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/font-awesome.min.css">
    <link rel="stylesheet" href="css/reset.css">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/animate.css">
    <link rel="stylesheet" href="css/responsive.css">
    <script src="js/vendor/modernizr-2.8.3.min.js"></script>

    <style>
        /* --- MODERN UI OVERRIDES --- */
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f8f9fa; /* Light gray background for contrast */
        }

        /* Smooth Page Loader */
        .page-loader {
            position: fixed;
            top: 0; left: 0; width: 100%; height: 100%;
            background-color: #fff; /* Clean white loader */
            z-index: 9999;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .loader-container .logo {
            width: 120px;
            animation: breathe 2s infinite ease-in-out;
        }
        @keyframes breathe {
            0%, 100% { transform: scale(1); opacity: 1; }
            50% { transform: scale(1.1); opacity: 0.8; }
        }

        /* Banner & Layout */
        .banner-section {
            background-image: url('img/appheader.png');
            background-size: cover;
            background-position: center;
            height: 220px;
            width: 100%;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .banner-overlay {
            background: rgba(0, 0, 0, 0.4);
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
        }
        .banner-title {
            position: relative;
            color: white;
            font-weight: 800;
            font-size: 2.5rem;
            text-shadow: 0 4px 10px rgba(0,0,0,0.3);
            z-index: 2;
        }

        /* The Main Floating Card */
        .order-card {
            background: #ffffff;
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            padding: 30px;
            margin-top: -60px; /* Pulls card up over banner */
            margin-bottom: 50px;
            position: relative;
            z-index: 10;
        }

        /* List Items Styling */
        .order-list {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0 10px;
        }
        .order-row {
            transition: transform 0.2s ease, box-shadow 0.2s ease;
            background: #fff;
            border-bottom: 1px solid #f0f0f0;
        }
        .order-row:hover {
            transform: scale(1.01);
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
            background: #fafafa;
            border-radius: 10px;
        }
        .order-details p {
            margin: 0;
            font-size: 14px;
            color: #555;
            line-height: 1.4;
        }
        .order-details p:first-child {
            font-weight: 600;
            color: #333;
        }

        /* Cancel Button */
        .cancel-btn {
            background: transparent;
            border: 1px solid #ff4d4d;
            color: #ff4d4d;
            border-radius: 20px;
            padding: 5px 15px;
            font-size: 12px;
            font-weight: 600;
            transition: all 0.3s;
            cursor: pointer;
            white-space: nowrap;
        }
        .cancel-btn:hover {
            background: #ff4d4d;
            color: white;
            box-shadow: 0 4px 10px rgba(255, 77, 77, 0.3);
        }

        /* Total Price */
        .total-price-box {
            background: #fdfdfd;
            border: 2px dashed #eee;
            border-radius: 15px;
            padding: 20px;
            text-align: center;
            margin: 20px 0;
        }
        .total-label { font-size: 14px; color: #888; text-transform: uppercase; letter-spacing: 1px; }
        .total-amount { font-size: 28px; font-weight: 800; color: #6a1b9a; /* Purple branding */ }

        /* Action Buttons Container */
        .actions-container {
            display: flex;
            flex-direction: column;
            gap: 15px;
            align-items: center;
        }

        /* Modern Gradient Buttons */
        .btn-checkout {
            width: 100%;
            background: linear-gradient(135deg, #fce63a, #f5c518);
            color: #1a1a1a;
            padding: 15px;
            border: none;
            border-radius: 50px;
            font-size: 18px;
            font-weight: 700;
            cursor: pointer;
            box-shadow: 0 8px 20px rgba(245, 197, 24, 0.4);
            transition: all 0.3s ease;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
        }
        .btn-checkout:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 25px rgba(245, 197, 24, 0.5);
        }

        .btn-order-more {
            background: transparent;
            color: #555;
            border: 2px solid #eee;
            padding: 10px 30px;
            border-radius: 50px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        .btn-order-more:hover {
            border-color: #f5c518;
            color: #f5c518;
            background: #fff;
        }
    </style>
</head>

<body id="content">
    
    <div class="page-loader">
        <div class="loader-container">
            <img src="img/logo/merlogo.png" alt="Logo" class="logo">
        </div>
    </div>
    <script>
        window.onload = function() {
            setTimeout(function() {
                document.querySelector('.page-loader').style.opacity = '0';
                setTimeout(() => {
                    document.querySelector('.page-loader').style.display = 'none';
                }, 500);
            }, 1000);
        };
    </script>

    <?php
    include 'conn.php';
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $quantity = $_POST['qty'];
        $addon1 = isset($_POST['addon1']) ? $_POST['addon1'] : "";
        $addon1_price = isset($_POST['addon1']) ? $_POST['addon1price'] : "";
        $soft = $_POST['soft']; $softprice = $_POST['softprice']; $softqty = $_POST['softqty'];
        $slushy = $_POST['slushy']; $slushyprice = $_POST['slushyprice']; $slushyqty = $_POST['slushyqty'];
        $colada = $_POST['colada']; $coladaprice = $_POST['coladaprice']; $coladaqty = $_POST['coladaqty'];
        $signature = $_POST['signature']; $signatureprice = $_POST['signatureprice']; $signatureqty = $_POST['signatureqty'];
        $booster = $_POST['booster']; $boosterprice = $_POST['boosterprice']; $boosterqty = $_POST['boosterqty'];
        $thickshake = $_POST['thickshake']; $thickshakeprice = $_POST['thickshakeprice']; $thickshakeqty = $_POST['thickshakeqty'];
        $milkshake = $_POST['milkshake']; $milkshakeprice = $_POST['milkshakeprice']; $milkshakeqty = $_POST['milkshakeqty'];
        $smoothie = $_POST['smoothie']; $smoothieprice = $_POST['smoothieprice']; $smoothieqty = $_POST['smoothieqty'];
        $lemonade = $_POST['lemonade']; $lemonadeprice = $_POST['lemonadeprice']; $lemonadeqty = $_POST['lemonadeqty'];
        $coffee = $_POST['coffee']; $coffeeprice = $_POST['coffeeprice']; $coffeeqty = $_POST['coffeeqty'];
        $icecoffee = $_POST['icecoffee']; $icecoffeeprice = $_POST['icecoffeeprice']; $icecoffeeqty = $_POST['icecoffeeqty'];
        $icetea = $_POST['icetea']; $iceteaprice = $_POST['iceteaprice']; $iceteaqty = $_POST['iceteaqty'];
        $tea = $_POST['tea']; $teaprice = $_POST['teaprice']; $teaqty = $_POST['teaqty'];
        $drink = $_POST['drink']; $drinkprice = $_POST['drinkprice']; $drinkqty = $_POST['drinkqty'];

        $item = $_POST['item']; $price = $_POST['price']; $name = $_POST['name'];
        $phone = $_POST['phone']; $status = $_POST['status']; $date = $_POST['date'];
        $location = $_POST['location']; $branch = $_POST['branch'];

        $sql = "INSERT INTO drinksorders (qty, addon1, addon1price, drink, drinkprice, tea, teaprice, icetea, iceteaprice, icecoffee, icecoffeeprice, coffee, coffeeprice, lemonade, lemonadeprice, smoothie, smoothieprice, thickshake, thickshakeprice, booster, boosterprice, signature, signatureprice, colada, coladaprice, slushy, slushyprice, soft, softprice, milkshake, milkshakeprice, drinkqty, teaqty, iceteaqty, icecoffeeqty, coffeeqty, lemonadeqty, smoothieqty, thickshakeqty, boosterqty, signatureqty, coladaqty, slushyqty, softqty, milkshakeqty, item, price, name, phone, status, location, date, branch) VALUES ('$quantity', '$addon1', '$addon1_price','$drink','$drinkprice','$tea', '$teaprice','$icetea', '$iceteaprice','$icecoffee', '$icecoffeeprice','$coffee', '$coffeeprice','$lemonade', '$lemonadeprice','$smoothie', '$smoothieprice','$thickshake', '$thickshakeprice','$booster', '$boosterprice','$signature', '$signatureprice','$colada', '$coladaprice','$slushy', '$slushyprice','$soft', '$softprice','$milkshake', '$milkshakeprice', '$drinkqty', '$teaqty', '$iceteaqty', '$icecoffeeqty', '$coffeeqty', '$lemonadeqty', '$smoothieqty', '$thickshakeqty', '$boosterqty', '$signatureqty', '$coladaqty','$slushyqty', '$softqty', '$milkshakeqty', '$item', '$price', '$name', '$phone', '$status', '$location', '$date','$branch')";

        if (mysqli_query($conn, $sql)) { echo ""; } else { echo "Error: " . $sql . "<br>" . mysqli_error($conn); }
    }
    ?>

    <div class="banner-section">
        <div class="banner-overlay"></div>
        <div class="banner-title">Your Order</div>
    </div>

    <div class="container">
        
        <div class="order-card">
            
            <?php
            include('conn.php');
            $customer = $_POST['customer'];
            $name = $_POST['name'];
            $phone = $_POST['phone'];
            $query = mysqli_query($conn, "SELECT * FROM `drinksorders` WHERE name='$name' AND phone='$phone' and status='pending'");
            ?>

            <table class="order-list">
                <?php while($row = mysqli_fetch_array($query)){ ?>
                <tr class="order-row" id="row-<?php echo $row['id']; ?>" data-id="<?php echo $row['id']; ?>">
                    <td style="padding: 15px;">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="order-details">
                                <?php if(!empty($row['addon1'])) echo "<p>• {$row['addon1']}</p>"; ?>
                                <?php if(!empty($row['drink'])) echo "<p>• {$row['drink']}</p>"; ?>
                                <?php if(!empty($row['tea'])) echo "<p>• {$row['tea']}</p>"; ?>
                                <?php if(!empty($row['icetea'])) echo "<p>• {$row['icetea']}</p>"; ?>
                                <?php if(!empty($row['icecoffee'])) echo "<p>• {$row['icecoffee']}</p>"; ?>
                                <?php if(!empty($row['coffee'])) echo "<p>• {$row['coffee']}</p>"; ?>
                                <?php if(!empty($row['lemonade'])) echo "<p>• {$row['lemonade']}</p>"; ?>
                                <?php if(!empty($row['smoothie'])) echo "<p>• {$row['smoothie']}</p>"; ?>
                                <?php if(!empty($row['thickshake'])) echo "<p>• {$row['thickshake']}</p>"; ?>
                                <?php if(!empty($row['booster'])) echo "<p>• {$row['booster']}</p>"; ?>
                                <?php if(!empty($row['signature'])) echo "<p>• {$row['signature']}</p>"; ?>
                                <?php if(!empty($row['colada'])) echo "<p>• {$row['colada']}</p>"; ?>
                                <?php if(!empty($row['slushy'])) echo "<p>• {$row['slushy']}</p>"; ?>
                                <?php if(!empty($row['soft'])) echo "<p>• {$row['soft']}</p>"; ?>
                                <?php if(!empty($row['milkshake'])) echo "<p>• {$row['milkshake']}</p>"; ?>
                            </div>
                            <button class="cancel-btn" onclick="deleteItem(<?php echo $row['id']; ?>)">
                                <i class="fa fa-times"></i> Cancel
                            </button>
                        </div>
                    </td>
                </tr>
                <?php } ?>
            </table>

            <?php
            include('conn.php');
            $query = mysqli_query($conn, "SELECT FORMAT(SUM((drinkprice * drinkqty) + (teaprice * teaqty) + (iceteaprice * iceteaqty) + (icecoffeeprice * icecoffeeqty) + (coffeeprice * coffeeqty) + (lemonadeprice * lemonadeqty) + (smoothieprice * smoothieqty) + (thickshakeprice * thickshakeqty) + (boosterprice * boosterqty) + (signatureprice * signatureqty) + (coladaprice * coladaqty) + (slushyprice * slushyqty) + (softprice * softqty) + (milkshakeprice * milkshakeqty)), 0) AS total_sum FROM drinksorders WHERE name='$name' AND phone='$phone' and status='pending'");
            $row = mysqli_fetch_array($query);
            $total_sum = $row['total_sum'];
            ?>

            <div class="total-price-box">
                <div class="total-label">Current Total</div>
                <div class="total-amount"><?php echo $total_sum; ?> UGX</div>
            </div>

            <div class="actions-container">
                <form action="checkout.php" method="post" style="width: 100%;">
                    <input style="display:none;" type="text" name="name" value="<?php echo $_POST['name']; ?>">
                    <input style="display:none;" type="text" name="phone" value="<?php echo $_POST['phone']; ?>">
                    <input style="display:none;" type="text" name="location" value="<?php echo $_POST['location']; ?>"> 
                    <input style="display:none;" type="text" name="branch" value="<?php echo $_POST['branch']; ?>"> 

                    <button type="submit" id="skipButton" class="btn-checkout">
                        <span>Check Out</span> <i class="fa fa-arrow-right"></i>
                    </button>
                </form>

                <form action="home.php" method="post">
                    <input style="display:none;" type="text" name="name" value="<?php echo $_POST['name']; ?>">
                    <input style="display:none;" type="text" name="phone" value="<?php echo $_POST['phone']; ?>">
                    <input style="display:none;" type="text" name="location" value="<?php echo $_POST['location']; ?>"> 
                    <input style="display:none;" type="text" name="branch" value="<?php echo $_POST['branch']; ?>"> 

                    <button type="submit" class="btn-order-more">
                        <i class="fa fa-plus"></i> Add More Items
                    </button>
                </form>
            </div>

        </div> </div> <script>
    function deleteItem(id) {
        if (confirm('Are you sure you want to cancel order?')) {
            var xhr = new XMLHttpRequest();
            xhr.open("POST", "deletedrinkitem.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4) {
                    if (xhr.status === 200) {
                        var response = JSON.parse(xhr.responseText);
                        if (response.success) {
                            var row = document.getElementById('row-' + id);
                            // Add fade out effect
                            row.style.opacity = '0';
                            setTimeout(() => row.remove(), 300);
                        } else {
                            alert('Error: ' + response.message);
                        }
                    } else {
                        alert('Error: Unable to contact server.');
                    }
                }
            };
            xhr.send("id=" + id);
        }
    }
    </script> 

    <script src="js/vendor/jquery-1.12.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
</body>
</html>
