<?php
// Database connection
include 'conn.php';

if (isset($_POST['location'])) {
    $location = mysqli_real_escape_string($conn, $_POST['location']);

    // Fetch branches for the selected location
    $stmt = $conn->prepare("SELECT branch FROM locations WHERE location = ?");
    $stmt->bind_param("s", $location);
    $stmt->execute();
    $result = $stmt->get_result();

    // Fetch all branches and return them as a JSON array
    $branches = [];
    while ($row = $result->fetch_assoc()) {
        $branches[] = $row;
    }

    echo json_encode($branches);
}
?>