<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<title>Middle East Restaurant - Delivery Portal</title>
<meta name="description" content="Experience Delicious Middle East Cuisine Delivered Fast">
<meta name="author" content="Omnis Business Hub">

<!-- Fonts & Icons -->
<link href="https://fonts.googleapis.com/css?family=Roboto|Righteous|Poppins&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

<!-- CSS -->
<link rel="stylesheet" href="css/bootstrap.min.css">
<link rel="stylesheet" href="css/owl.carousel.min.css">
<link rel="stylesheet" href="css/reset.css">
<link rel="stylesheet" href="css/style.css">
<link rel="stylesheet" href="css/animate.css">
<link rel="stylesheet" href="css/responsive.css">

<!-- Favicon -->
<link rel="icon" type="image/png" href="merlogo.png" sizes="32x32">
<link rel="icon" type="image/png" href="merlogo.png" sizes="16x16">

<style>
/* ======== RESET & BASE ======== */
html, body {
    overflow-x: hidden;
    margin: 0;
    padding: 0;
    font-family: 'Roboto', sans-serif;
}

/* ======== HEADER ======== */
.header-container {
    width: 100%;
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 28px 18px;
    position: relative;
    z-index: 100;
}

.header-logo {
    width: 100px;
    height: 100px;
    border-radius: 50%;
    object-fit: cover;
    /* Cleaner, softer shadow for a modern look */
    
box-shadow: 0 10px 18px rgba(0,0,0,0.433), inset 0 0 0 2px yellow;   
    position: absolute;
    left: 50%;
    /* Start the transition with a subtle spring-like movement */
    transform: translateX(-50%); 
    animation: springIn 1.2s cubic-bezier(0.175, 0.885, 0.32, 1.275) forwards;
    opacity: 0; /* Start invisible */
    /* Add a transition for the hover effects */
    transition: transform 0.3s ease-in-out, box-shadow 0.3s ease-in-out, opacity 0.3s ease-in-out;
}

.header-logo:hover {
    /* Scale up and add a very slight rotation for an organic feel */
    transform: translateX(-50%) scale(1.1) rotate(2deg);
    /* Make the shadow pop a little on hover */
    box-shadow: 0 12px 25px rgba(0, 0, 0, 0.25);
}

/* New, smoother animation with a spring effect */
@keyframes springIn {
    0% { transform: translate(-50%, -150px); opacity: 0; }
    50% { transform: translate(-50%, 15px); opacity: 1; } /* Overshoot */
    100% { transform: translate(-50%, 0); opacity: 1; }
}




/* Circle Buttons */
.circle-button {
    background-color:;
    color: black;
    width: 58px; height: 58px;
    border: none;
    border-radius: 50%;
    font-size: 22px;
    cursor: pointer;
    display: flex; align-items: center; justify-content: center;
    box-shadow: 0 8px 15px rgba(0,0,0,0.4),
                inset 0 0 0 3px white;
                
    transition: 0.25s ease;
}
.circle-button:active { transform: scale(0.92); }
.circle-button.bounce { animation: bounce 0.5s; }

@keyframes bounce {
  0% { transform: scale(1); }
  30% { transform: scale(0.9); }
  60% { transform: scale(1.05); }
  100% { transform: scale(1); }
}

/* ======== IMAGE GRID ======== */
.image-container {
  padding: 12px 0;
  margin-top: 28px;
  display: flex;
  justify-content: center;
  align-items: flex-start;
  flex-wrap: wrap;
  gap: 10px;
  width: 90%;
  max-width: 800px;
  margin-left: auto; margin-right: auto;
  
}

.image-wrapper {
  text-align: center;
  width: 48%;
  box-sizing: border-box;
  margin: 0 auto;
}

.image-wrapper img {
  width: 100%; height: auto;
  border-radius: 12px;
  box-shadow: 0px 10px 16px #00000062;
  transition: transform 0.2s, box-shadow 0.2s;
}

.image-wrapper button {
    border: none;
    background: none;
    cursor: pointer;
    width: 100%;
    transition: transform 0.18s ease, box-shadow 0.18s ease;
}

.image-wrapper button:active {
    transform: scale(0.98);
    box-shadow: 0 18 28px rgba(255, 230, 120, 0.8);
}

.image-wrapper button:hover {
    box-shadow: 0 0 12px rgba(255, 235, 140, 0.5);
}

.image-wrapper h3 {
  font-size: 14px;
  font-weight: bold;
}

/* ======== MODALS ======== */
.modal-overlay {
  position: fixed;
  top:0; left:0;
  width:100%; height:100%;
  display:flex;
  justify-content:center;
  align-items:center;
  background: rgba(0,0,0,0.55);
  backdrop-filter: blur(3px);
  display: none;
  z-index: 9999;
}

.modal-box {
  background:#fff;
  padding: 25px 30px;
  border-radius:18px;
  width:85%;
  max-width:380px;
  text-align:center;
  box-shadow:0 10px 35px rgba(0,0,0,0.15);
  animation: popIn 0.25s ease-out;
}

.modal-box h3, .modal-box h2 { margin-bottom: 10px; }
.modal-box p { margin-bottom: 20px; color:#333; }
.modal-box button {
    padding: 8px 22px;
    border:none;
    border-radius:12px;
    cursor:pointer;
    font-weight:600;
    background:#ff3b30;
    color:#fff;
    transition:0.2s;
}
.modal-box button:hover { background:#e53028; }

@keyframes popIn { from {transform:scale(0.7); opacity:0;} to {transform:scale(1);opacity:1;} }

</style>
</head>
<body id="content">

<!-- HEADER -->
<div class="header-container">
    <form id="orderForm2" action="details.php" method="post">
        <input type="hidden" name="name" id="name-user">
        <input type="hidden" name="phone" id="phone-user">
        <input type="hidden" name="location" id="location-user">
        <input type="hidden" name="branch" id="branch-user">
        <input type="hidden" name="date" value="<?php date_default_timezone_set('Africa/Kampala'); echo date('Y-m-d H:i:s'); ?>">
        <button type="submit" id="userButton" class="circle-button"><i class="fas fa-bars"></i></button>
    </form>

    <img src="img/logo/merlogo.png" class="header-logo" alt="Logo">

    <form id="orderForm1" action="checkout.php" method="post">
        <input type="hidden" name="name" id="name-checkout">
        <input type="hidden" name="phone" id="phone-checkout">
        <input type="hidden" name="location" id="location-checkout">
        <input type="hidden" name="branch" id="branch-checkout">
        <input type="hidden" name="date" value="<?php date_default_timezone_set('Africa/Kampala'); echo date('Y-m-d H:i:s'); ?>">
        <button type="submit" id="bagButton" class="circle-button"><i class="fas fa-shopping-bag"></i></button>
    </form>
</div>

<!-- IMAGE GRID -->
<div class="image-container">
  <!-- Breakfast -->
  <div class="image-wrapper">
    <form action="breakfasthome.php" method="post">
        <input type="hidden" name="name" id="name-breakfast">
        <input type="hidden" name="phone" id="phone-breakfast">
        <input type="hidden" name="location" id="location-breakfast">
        <input type="hidden" name="branch" id="branch-breakfast">
        <input type="hidden" name="date" value="<?php date_default_timezone_set('Africa/Kampala'); echo date('Y-m-d H:i:s'); ?>">
        <button type="button" id="breakfast-btn">
          <img src="img/homepage/breakfastmain.png" alt="Breakfast">
          <h3>BREAKFAST COMBOS</h3>
        </button>
    </form>
  </div>

  <!-- Monthly Promos -->
  <div class="image-wrapper">
    <form action="promohome.php" method="post">
        <input type="hidden" name="name" id="name-promo">
        <input type="hidden" name="phone" id="phone-promo">
        <input type="hidden" name="location" id="location-promo">
        <input type="hidden" name="branch" id="branch-promo">
        <input type="hidden" name="date" value="<?php date_default_timezone_set('Africa/Kampala'); echo date('Y-m-d H:i:s'); ?>">
        <button type="submit">
          <img src="img/homepage/promosmain.png" alt="Promo">
          <h3>PROMOS<span id="comingBadge">Hot Offers!</span></h3>
        </button>
    </form>
  </div>

  <!-- Main Course -->
  <div class="image-wrapper">
    <form action="mainhome1.php" method="post">
        <input type="hidden" name="name" id="name-main">
        <input type="hidden" name="phone" id="phone-main">
        <input type="hidden" name="location" id="location-main">
        <input type="hidden" name="branch" id="branch-main">
        <input type="hidden" name="date" value="<?php date_default_timezone_set('Africa/Kampala'); echo date('Y-m-d H:i:s'); ?>">
        <button type="submit">
          <img src="img/homepage/mainmainhome.png" alt="Main">
          <h3>MAIN COURSE</h3>
        </button>
    </form>
  </div>

  <!-- Drinks -->
  <div class="image-wrapper">
    <form action="drinkshome2.php" method="post">
        <input type="hidden" name="name" id="name-drinks">
        <input type="hidden" name="phone" id="phone-drinks">
        <input type="hidden" name="location" id="location-drinks">
        <input type="hidden" name="branch" id="branch-drinks">
        <input type="hidden" name="date" value="<?php date_default_timezone_set('Africa/Kampala'); echo date('Y-m-d H:i:s'); ?>">
        <button type="submit">
          <img src="img/homepage/drinksmain.png" alt="Drinks">
          <h3>GRAB A DRINK</h3>
        </button>
    </form>
  </div>

  <!-- Desserts -->
  <div class="image-wrapper">
    <form action="desserthome.php" method="post">
        <input type="hidden" name="name" id="name-dessert">
        <input type="hidden" name="phone" id="phone-dessert">
        <input type="hidden" name="location" id="location-dessert">
        <input type="hidden" name="branch" id="branch-dessert">
        <input type="hidden" name="date" value="<?php date_default_timezone_set('Africa/Kampala'); echo date('Y-m-d H:i:s'); ?>">
        <button type="submit">
          <img src="img/homepage/dessertmain.png" alt="Dessert">
          <h3>DESSERTS N' CAKES</h3>
        </button>
    </form>
  </div>
  
  <!-- Kids -->
  <div class="image-wrapper">
    <form action="kidshome.php" method="post">
        <input type="hidden" name="name" id="name-kids">
        <input type="hidden" name="phone" id="phone-kids">
        <input type="hidden" name="location" id="location-kids">
        <input type="hidden" name="branch" id="branch-kids">
        <input type="hidden" name="date" value="<?php date_default_timezone_set('Africa/Kampala'); echo date('Y-m-d H:i:s'); ?>">
      <button type="submit">
  <img src="img/kids/Kidsmain2.png" alt="Dessert">
<h3 style="white-space: nowrap;">
  KIDS' CORNER</h3>
  <style>#comingBadge {
  background: #ff0055;
  color: white;
  font-size: 10px;
  font-weight: 700;
  padding: 5px 8px;
  border-radius: 12px;
  margin-left: 2px;

  /* Sticker effect */
  box-shadow: 0 3px 8px rgba(0,0,0,0.25);
  border: 2px solid white;

  /* Slight rotation for cool badge look */
  transform: rotate(-8deg);
  display: inline-block;

  /* Pop-in animation */
  animation: popIn 0.35s ease-out;
}

@keyframes popIn {
  0% { transform: scale(0) rotate(-8deg); opacity: 0; }
  100% { transform: scale(1) rotate(-8deg); opacity: 1; }
}
</style>
</button>

    </form>
  </div>
</div>



  <hr style="border-bottom: solid 1px yellow;">
   <center>
        <span style="font-size:11px; color:grey;">Middle East Restaurant Delivery Portal V 2.0</span>
</center>
<!-- ======== MODALS ======== -->
<!-- Breakfast Time Modal -->
<div id="timeModal" class="modal-overlay">
  <div class="modal-box">
    <h3>Sorry 😕</h3>
    <p>We can't take breakfast orders at this time.<br>Breakfast runs 6AM to 12PM.</p>
    <button id="closeTimeModal">OK</button>
  </div>
</div>

<!-- Closed Hours Modal -->
<div id="closedModal" class="modal-overlay">
  <div class="modal-box">
    <p>Sorry, we're closed.<br>Open 6AM TO 12AM.</p>
    <button id="closeClosedModal">OK</button>
  </div>
</div>

<!-- BOGO Promo Modal -->
<div id="bogoModal" class="modal-overlay">
  <div class="modal-box">
    <h2>🍕 Buy One Pizza, Get One FREE!</h2>
    <p>Every <strong>Monday</strong> and <strong>Friday</strong>.</p>
    <button id="closeBogoModal">Got it</button>
  </div>
</div>

<!-- JS -->
<script>
// ==========================
// USER INFO POPULATION
// ==========================
const user = {
    name: localStorage.getItem("name") || "",
    phone: localStorage.getItem("phone") || "",
    location: localStorage.getItem("location") || "",
    branch: localStorage.getItem("branch") || ""
};

// Populate all hidden fields
function populateHiddenFields() {
    const forms =
    ['user','checkout','breakfast','promo','main','drinks','dessert','kids'];
    forms.forEach(suffix => {
        Object.keys(user).forEach(field => {
            const el = document.getElementById(field + '-' + suffix);
            if(el) el.value = user[field];
        });
    });
}
document.addEventListener('DOMContentLoaded', populateHiddenFields);

// ==========================
// BUTTON BOUNCE
// ==========================
document.querySelectorAll('.circle-button').forEach(btn => {
    btn.addEventListener('click', () => {
        btn.classList.add('bounce');
        setTimeout(() => btn.classList.remove('bounce'), 500);
    });
});

// ==========================
// MODAL HANDLERS
// ==========================
function showModal(modal) { modal.style.display = 'flex'; }
function hideModal(modal) { modal.style.display = 'none'; }

const timeModal = document.getElementById('timeModal');
const closedModal = document.getElementById('closedModal');
const bogoModal = document.getElementById('bogoModal');

document.getElementById('closeTimeModal').onclick = () => hideModal(timeModal);
document.getElementById('closeClosedModal').onclick = () => hideModal(closedModal);
document.getElementById('closeBogoModal').onclick = () => hideModal(bogoModal);

// ==========================
// BREAKFAST TIME CHECK
// ==========================
document.getElementById('breakfast-btn').addEventListener('click', function() {
    const now = new Date();
    const hour = now.getHours();
    if(hour >= 6 && hour < 12) {
        this.closest('form').submit();
    } else {
        showModal(timeModal);
    }
});

// ==========================
// CLOSED HOURS CHECK
// ==========================
function isOpenHours() {
    const now = new Date();
    const ugandaTime = new Date(now.toLocaleString("en-US", {timeZone: "Africa/Kampala"}));
    const hour = ugandaTime.getHours();
    return hour >= 6 && hour < 23;
}

document.querySelectorAll('.image-wrapper form').forEach(form => {
    form.addEventListener('submit', function(e) {
        if(!isOpenHours()) {
            e.preventDefault();
            showModal(closedModal);
        }
    });
});

// ==========================
// BOGO MODAL
// ==========================
document.addEventListener('DOMContentLoaded', () => {
    const now = new Date();
    const kampala = new Date(now.toLocaleString("en-US", {timeZone: "Africa/Kampala"}));
    const day = kampala.getDay();
    if(day === 1 || day === 5) showModal(bogoModal);
});
</script>

</body>
</html>