<!-- Pop-up Ad -->
<div id="popup-overlay">
  <div id="popup-ad">
    <span id="popup-close">&times;</span>

    <!-- Ad 1 -->
    <div class="ad-item active">
      <img src="img/pizza/VEGETARIANPIZZA.jpg" alt="Pizza Ad">
      <h2>Special Offers Just for You!</h2>
      <p>BUY ONE GET ONE FREE ON PIZZAS<br><strong>Monday & Friday</strong> only!</p>
      <p class="hint">Swipe or Tap to see more</p>
    </div>

    <!-- Ad 2 -->
    <div class="ad-item">
      <img src="img/homepage/shawarmamain.png" alt="Shawarma Ad">
      <h2>New Offers On Promos!</h2>
<p>NEW AWESOME PROMOS JUST FOR YOU<br>Check em Out!</p>
      <p class="hint">Swipe or Tap to see more</p>
    </div>
  </div>
</div>
<!-- Style -->
<style>
#popup-overlay {
  position: fixed;
  top: 0; left: 0;
  width: 100vw;
  height: 100vh;
  background: rgba(0, 0, 0, 0.6);
  display: flex;
  align-items: center;
  justify-content: center;
  backdrop-filter: blur(3px);
  z-index: 9999;
  opacity: 0;
  pointer-events: none;
  transition: opacity 0.5s ease;
}
#popup-overlay.active {
  opacity: 1;
  pointer-events: all;
}

#popup-ad {
  background: #fff;
  padding: 20px;
  border-radius: 16px;
  width: 90%;
  max-width: 340px;
  text-align: center;
  position: relative;
  box-shadow: 0 8px 30px rgba(0,0,0,0.25);
  font-family: 'Segoe UI', sans-serif;
  transform: translateY(-30px);
  opacity: 0;
  transition: transform 0.5s ease, opacity 0.5s ease;
}
#popup-overlay.active #popup-ad {
  transform: translateY(0);
  opacity: 1;
}

#popup-close {
  position: absolute;
  top: 10px;
  right: 15px;
  font-size: 22px;
  font-weight: bold;
  color: #888;
  cursor: pointer;
  transition: color 0.3s ease;
}
#popup-close:hover {
  color: #333;
}

.ad-item {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  opacity: 0;
  transform: translateY(30px);
  transition: opacity 0.6s ease, transform 0.6s ease;
  pointer-events: none;
}
.ad-item img {
  width: 100%;
  height: auto;
  max-height: 200px;
  object-fit: cover;
  border-radius: 10px;
  display: block;
}
.ad-item h2 {
  margin-top: 15px;
  color: #222;
}
.ad-item p {
  color: #666;
}
.hint {
  font-size: 10px;
  color: #aaa;
}

/* Active ad */
.ad-item.active {
  opacity: 1;
  transform: translateY(0);
  pointer-events: all;
  position: relative;
  z-index: 1;
}
</style>
<!-- Script -->
<script>
document.addEventListener("DOMContentLoaded", () => {
  const overlay = document.getElementById('popup-overlay');
  const popup = document.getElementById('popup-ad');
  const closeBtn = document.getElementById('popup-close');
  const ads = document.querySelectorAll('.ad-item');
  let currentAd = 0;
  let startX = 0;

  function showAd(index) {
    ads.forEach((ad, i) => {
      ad.classList.remove('active');
      ad.style.zIndex = '0';
    });
    ads[index].classList.add('active');
    ads[index].style.zIndex = '1';
  }

  function nextAd() {
    currentAd = (currentAd + 1) % ads.length;
    showAd(currentAd);
  }

  // Show popup
  setTimeout(() => {
    overlay.classList.add('active');
    showAd(currentAd);
  }, 500);

  // Swipe or tap
  popup.addEventListener('touchstart', e => startX = e.touches[0].clientX);
  popup.addEventListener('touchend', e => {
    const endX = e.changedTouches[0].clientX;
    if (Math.abs(endX - startX) > 30) nextAd();
  });

  popup.addEventListener('click', () => nextAd());

  // Close popup
  closeBtn.onclick = () => overlay.classList.remove('active');
  overlay.onclick = (e) => {
    if (e.target.id === 'popup-overlay') overlay.classList.remove('active');
  };

  // Auto-slide
  setInterval(nextAd, 6000);
});
</script>
