<?php

// Set session cookie parameters to last for one day
session_set_cookie_params([
    'lifetime' => 86400, // Cookie will last for one day
    'path' => '/',
    'domain' => 'omnisservicehub.ug', // Use the domain without 'https://'
    'secure' => true, // Set to true if using HTTPS
    'httponly' => true,
    'samesite' => 'Lax', // Adjust according to your needs
]);

// Start the session
session_start();

// Check if the session variable 'name' is set
if (!isset($_SESSION['name'])) {
    // Redirect to login page if not set
    header("Location: index.html");
    exit();
}

// Retrieve the user's name from the session
$userName = $_SESSION['name'];
?>




<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <link href="https://fonts.googleapis.com/css?family=Raleway:100,300,400,500,700,900" rel="stylesheet">
   <title>Omnis Business Hub - Admin Hub</title>
    <!-- Additional CSS Files -->
  <link rel="stylesheet" type="text/css" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="assets/css/font-awesome.css">
    <link rel="stylesheet" href="assets/css/templatemo-softy-pinko.css">
   </head>
    <body>
    
    <!-- ***** Preloader Start ***** -->
    <div id="preloader">
        <div class="jumper">
            <div></div>
            <div></div>
            <div></div>
        </div>
    </div>  
    <!-- ***** Preloader End ***** -->

    <!-- ***** Contact Us Start ***** -->
    <section  style="display:;" class="section colored" id="contact-us">

    <!-- ***** Header Area Start ***** -->
<header class="header-area header-sticky">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <div style="overflow-x: auto; display: block; white-space: nowrap; background-color:#ffffffb6; border-radius:24px; padding:10px 20px;">
          <div style="display: flex; flex-wrap: wrap;">
            <div style="flex: 1;">
               <a style="text-decoration: none; color: #00809c; padding: 4px 8px; border-radius: 8px; border: 2px solid #00809c; transition: background-color 0.3s ease, color 0.3s ease; margin: 2px; display: inline-block; touch-action: manipulation; font-size:13px; font-weight:bold;" href="doctornurseview.php">DOCTOR'S LIST</a>

               <a style="text-decoration: none; color: #00809c; padding: 4px 8px; border-radius: 8px; border: 2px solid #00809c; transition: background-color 0.3s ease, color 0.3s ease; margin: 2px; display: inline-block; touch-action: manipulation; font-size:13px; font-weight:bold;" href="medicalreporthome.php">
    MEDICAL REPORT
               </a>

              <a style="text-decoration: none; color: #ff0000; padding: 4px 8px; border-radius: 8px; border: 2px solid #ff0000; transition: background-color 0.3s ease, color 0.3s ease; margin: 2px; display: inline-block; touch-action: manipulation; font-size:13px; font-weight:bold;" href="index.html" onclick="destroySession(event)">CLOSE</a>

              <script>
                function destroySession(event) {
                  event.preventDefault(); // Prevent the default anchor behavior
                  // Make an AJAX request to the PHP script to destroy the session
                  fetch('endsession.php', {
                    method: 'POST',
                    credentials: 'same-origin'
                  }).then(response => {
                    if (response.ok) {
                      // Redirect to the index page after session destruction
                      window.location.href = 'index.html';
                    } else {
                      console.error('Failed to destroy session.');
                    }
                  }).catch(error => {
                    console.error('Error destroying session:', error);
                  });
                }
              </script>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</header>
<!-- ***** Header Area End ***** -->


    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f6f9;
            padding: 20px;
        }
        .container {
            max-width: ;
            margin: auto;
            background:#ffffff51;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
        }
        h2 {
            color: #4A148C;
            text-align: center;
            font-size: 22px;
        }
        .patient-count {
            color: #4A148C;
            font-size: 18px;
            font-weight: bold;
            text-align:left;
            margin-bottom: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }
        th, td {
            padding: 10px;
            text-align: left;
            border-bottom: 1px solid #ddd;
            font-size: 13px;
        }
        th {
            background-color: #4A148C;
            color: white;
            text-transform: uppercase;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        tr:hover {
            background-color: #e0e0e0;
            cursor: pointer;
        }
        .details {
            display: none;
            background-color: #e6e6e6;
        }
        .details td {
            padding: 8px;
        }
        .details a {
            color: #4A148C;
            text-decoration: none;
            font-weight: bold;
        }
        .details a:hover {
            text-decoration: underline;
        }
        .note {
            font-size: 12px;
            color: #777;
            text-align: center;
            margin-top: 5px;
        }
    </style>



        <div class="container">     
    <details style="margin-top:14px; display:none;">
 <summary class="circle-arrow">View Notes:</summary>
<style>

  .circle-arrow {

 
    width:70%;
    max-width: 250px;
  
    border-radius:8px;
    color:white;
    background-color:; /* Light grey background */
    text-align: center;
 color: #052c3a;
    cursor: pointer;
    font-size: 14px; /* Adjust as needed */
    padding: 5px 50px;
  
    border: 1px solid #052c3a; /* Optional border */
  }
</style>


 <form id="contact" action="medicalreportview.php" method="post" style="width:50%;">
   <span style="color:purple; font-weight:; font-size:14px;">Enter patient name: </span>   
        <fieldset>
    <input name="pname" type="search" list="name" class="form-control"   autocomplete="off" required style="border-radius:34px;">      	
       <datalist id="name">
	 <?php
        include "dbConn.php";  // Using database connection file here
         	$class = $_POST['class'];
        $records = mysqli_query($db, "SELECT * from patientdata order by pname");  // Use select query here 
        while($data = mysqli_fetch_array($records))
        {
        echo "<option value='". $data['pname'] ."'>";  // displaying data in option menu
        }	
    ?>   
   </fieldset>
<fieldset>
Enter Date:           
<input name="date" type="date" class="form-control"  style="border-radius:34px;"/>
  </fieldset>   
           <hr> 
                    <fieldset>
<button type="submit" id="form-submit"
  class="main-button">Fetch Notes</button>
                    </fieldset>
        
        </form>

</details>
<hr style="border:thin blue dashed;">
<br>
		 <div class="row">
                <!-- ***** Contact Form Start ***** -->
 <div class="col-lg-8 col-md-6 col-sm-12">
              <div class="contact-form">
  <body style="background-color:#d3d3d3;">
    <h4>Patient Referral Form</h4>
<hr>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: ;
            padding: 20px;
        }
        .form-container {
            background: ;
            border-radius: 8px;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
            padding: 20px;
            max-width: 600px;
            margin: auto;
        }
        .form-container h4 {
            color: #003a64;
            font-weight: bold;
            margin-bottom: 20px;
        }
        .form-control {
            border-radius: 8px;
            padding: 10px;
        }
        label {
            font-size: 14px;
            font-weight: bold;
            color: #555555;
            margin-bottom: 5px;
        }
        textarea {
            resize: none;
        }
        .btn-submit {
            border-radius: 24px;
            width: 100%;
            background-color: #003a64;
            color: white;
            padding: 10px;
            border: none;
            font-size: 16px;
        }
        .btn-submit:hover {
            background-color: #005a91;
        }
    </style>
    <script>
        function fetchPatientDetails() {
            const patientName = document.getElementById('pname').value;

            if (patientName) {
                fetch(`fetchPatientDetails.php?pname=${encodeURIComponent(patientName)}`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            document.getElementById('age').value = data.age;
                            document.getElementById('gender').value = data.gender;
                        } else {
                            document.getElementById('age').value = '';
                            document.getElementById('gender').value = '';
                            alert(data.message || 'No details found for the selected patient.');
                        }
                    })
                    .catch(error => console.error('Error fetching patient details:', error));
            }
        }
    </script>
    
    
  <form method="POST" action="referral.php">
            <div class="mb-3">
                <label for="pname">Full Name:</label>
      <input name="pname" type="search" list="name" class="form-control"  onchange="fetchPatientDetails()" autocomplete="off" id="pname" required>
                <datalist id="name">
                    <?php
                        include "conn.php"; 
                        $records = mysqli_query($conn, "SELECT pname FROM patientdata ORDER BY pname"); 
                        while($data = mysqli_fetch_array($records)) {
                            echo "<option value='". $data['pname'] ."'>";
                        }	
                    ?>
                </datalist>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="age">Age:</label>
                    <input name="age" type="text" class="form-control" id="age">
                </div>
                <div class="col-md-6">
                    <label for="gender">Gender:</label>
                    <input name="gender" type="text" class="form-control" id="gender" >
                </div>
            </div>

            <div class="mb-3">
                <label for="doctors">Notes By:</label>
                <input name="doctor" type="search" list="doctors" class="form-control" autocorrect="off" required>
                <datalist id="doctors">
                    <?php
                        include "dbConn.php"; 
                        $records = mysqli_query($db, "SELECT name FROM doc ORDER BY name"); 
                        while($data = mysqli_fetch_array($records)) {
                            echo "<option value='". $data['name'] ."'>";
                        }	
                    ?>
                </datalist>
            </div>

            <div class="mb-3">
                <label for="date">Referral Date:</label>
                <input name="date" type="date" class="form-control" id="date">
            </div>

            <div class="mb-3">
     <label for="refer">Referral To:</label>
      <input name="refer" type="text" class="form-control" id="refer">
            </div>
 
   <div class="mb-3">
     <label for="diagnosis">Diagnosis:</label>
                <textarea name="diagnosis" class="form-control" id="diagnosis" rows="4"></textarea>
            </div>

            <div class="mb-3">
 <label for="treatment">Treatment Given:</label>
      <textarea name="treatment" class="form-control" id="treatment" rows="4"></textarea>
            </div>

            <div class="mb-3">
<label for="reason">Reason for referral:</label>
   <textarea name="reason" class="form-control" id="reason" rows="4"></textarea>
            </div>

         
            <button type="submit" class="btn-submit">Submit</button>
        </form>
</body>            
</div>
           
            </div>
 <!-- ***** Contact Form End ***** -->
            </div>
        </div>
    </section>
    <!-- ***** Contact Us End ***** -->

    
    <!-- jQuery -->
    <script src="assets/js/jquery-2.1.0.min.js"></script>
    <!-- Bootstrap -->
    <script src="assets/js/popper.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <!-- Plugins -->
    <script src="assets/js/scrollreveal.min.js"></script>
    <script src="assets/js/waypoints.min.js"></script>
    <script src="assets/js/jquery.counterup.min.js"></script>
    <script src="assets/js/imgfix.min.js"></script> 
    
    <!-- Global Init -->
    <script src="assets/js/custom.js"></script>

  </body>
</html>