<?php
include 'conn.php';

$name = $_POST['name'];
$phone = $_POST['phone'];
$locdetails = $_POST['locdetails'];
$location = $_POST['location'];
$password = $_POST['password'];
$branch = $_POST['branch'];
$email = $_POST['email'];

// Check if the user already exists
$checkUserQuery = "SELECT * FROM user WHERE email = ? OR phone = ?";
$stmt = $conn->prepare($checkUserQuery);
$stmt->bind_param("ss", $email, $phone);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // --- START MODERN POPUP CODE ---
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <style>body { font-family: sans-serif; background: #f4f4f4; }</style>
    </head>
    <body>
        <script>
            Swal.fire({
                icon: 'warning',
                title: 'Account Exists',
                text: 'A user with this email or phone number is already registered!',
                confirmButtonText: 'Go to Login',
                confirmButtonColor: '#3085d6',
                showCancelButton: true,
                cancelButtonText: 'Try Again'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Redirect to login page if they confirm
                    window.location.href = 'signin.html';
                } else {
                    // Redirect back to signup form if they cancel
                    window.location.href = 'signuphome.php'; // Change this to your actual signup file name
                }
            });
        </script>
    </body>
    </html>
    <?php
    // --- END MODERN POPUP CODE ---
    exit(); // Stop script execution here

} else {
    // Insert new user
    
    // SECURITY NOTE: Please see the section below about hashing passwords!
    $insertQuery = "INSERT INTO user (name, phone, locdetails, location, password, branch, email)
                    VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt2 = $conn->prepare($insertQuery);
    $stmt2->bind_param("sssssss", $name, $phone, $locdetails, $location, $password, $branch, $email);

    if ($stmt2->execute()) {
        // Success Popup (Optional, or keep your direct header redirect)
        header("Location: signin.html");
        exit();
    } else {
        echo "Error: " . $stmt2->error;
    }
}

$conn->close();
?>
