<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title>Middle East Restaurant - Delivery Portal</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Fonts & Icons -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    body {
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(135deg, #fff9e6, #ffecca);
    }

    /* Page Loader */
    .page-loader {
      position: fixed;
      inset: 0;
      background: linear-gradient(145deg, #ffe59e, #ffd36b);
      z-index: 9999;
      display: flex;
      justify-content: center;
      align-items: center;
      transition: opacity .6s ease;
    }
    .logo {
      width: 140px;
      animation: float 2.4s infinite ease-in-out;
      filter: drop-shadow(0 0 12px rgba(255,190,60,0.7));
    }
    @keyframes float {
      0%,100% { transform: translateY(0); opacity: 1; }
      50% { transform: translateY(-10px); opacity: 0.7; }
    }

    /* Glass Card */
    .glass-card {
      background: rgba(255,255,255,0.68);
      padding: 2.2rem;
      border-radius: 28px;
      backdrop-filter: blur(18px);
      box-shadow: 0 10px 45px rgba(0,0,0,0.12);
      transition: .3s ease;
    }
    .glass-card:hover {
      box-shadow: 0 14px 50px rgba(0,0,0,0.15);
    }

    .form-floating > label {
      font-size: 15px;
      opacity: .8;
    }

    .form-control {
      border-radius: 14px !important;
      padding: 14px !important;
      background: rgba(255,255,255,0.85);
      border: 1px solid #ddd;
      transition: all .25s ease;
    }
    .form-control:focus {
      box-shadow: 0 0 0 3px rgba(255,153,0,0.2);
      border-color: #ffb100;
      background: #fff;
    }

    .btn-submit {
      background: linear-gradient(135deg, #ff8d4c, #ffa851);
      border: none;
      color: white;
      font-weight: 600;
      padding: 12px;
      border-radius: 45px;
      transition: .25s ease;
    }
    .btn-submit:hover {
      box-shadow: 0 7px 18px rgba(255,140,60,0.4);
      background: linear-gradient(135deg, #ff7f40, #ff9c40);
    }

    .readonly-box {
      background: #f1f1f1 !important;
      cursor: not-allowed;
    }
    .form-floating > .form-control {
  padding-top: 1.6rem !important;
  padding-bottom: .6rem !important;
}

.form-floating > label {
  padding-top: .5rem;
}
  </style>
</head>

<body>

<section class="py-5 d-flex align-items-center" style="min-height:100vh;">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-12 col-md-10 col-lg-6">
        <div class="glass-card">

          <h4 class="text-center mb-4 fw-semibold text-dark">
            <i class="bi bi-person-plus-fill me-2"></i> Create Your Account
          </h4>

          <form action="signup.php" method="post" id="signup-form" novalidate>

            <div class="form-floating mb-3">
              <input type="text" class="form-control" name="name" placeholder="Full Name" required>
              <label><i class="bi bi-person-fill me-2"></i>Full Name</label>
            </div>

            <div class="form-floating mb-3">
              <input type="text" class="form-control" name="phone" placeholder="Phone" required>
              <label><i class="bi bi-telephone-fill me-2"></i>Phone Number</label>
            </div>

            <div class="form-floating mb-3">
              <input type="email" class="form-control" name="email" placeholder="Email" required>
              <label><i class="bi bi-envelope-fill me-2"></i>Email Address</label>
            </div>

            <!-- Password -->
            <div class="form-floating mb-3 position-relative">
              <input type="password" class="form-control" id="password" name="password" placeholder="Password" required>
              <label><i class="bi bi-lock-fill me-2"></i>Password</label>

              <span id="togglePassword"
                    style="position:absolute; right:15px; top:50%; transform:translateY(-50%); cursor:pointer;">
                <i class="bi bi-eye-fill"></i>
              </span>
            </div>

            <!-- Location -->
            <div class="mb-3 position-relative">
              <label class="form-label fw-semibold">Your Location</label>

              <input type="search"
                     class="form-control"
                     id="location-input"
                     name="location"
                     autocomplete="off"
                     placeholder="Start typing your location..."
                     required>

              <div id="location-list"
                   class="list-group position-absolute w-100 d-none"
                   style="max-height:220px; overflow-y:auto; z-index:1000;"></div>

              <div id="location-error" class="form-text text-danger d-none">
                ⚠️ Hi, your location seems outside our delivery radius please try again.
              </div>
            </div>

            <!-- Branch -->
            <div class="form-floating mb-4 d-none">
              <input type="text" id="branch" name="branch" class="form-control" readonly required>
              <label><i class="bi bi-shop me-2"></i>Branch (auto-filled)</label>
            </div>

            <div class="form-floating mb-4">
              <textarea class="form-control" name="locdetails" style="height:100px" required></textarea>
              <label><i class="bi bi-geo-alt-fill me-2"></i>Additional location info</label>
            </div>

            <button class="btn btn-submit w-100 mb-3">
              <i class="bi bi-check2-circle me-2"></i> Submit
            </button>

            <p class="text-center small">
              Already have an account?
              <a href="signin.html" class="fw-semibold text-primary">Sign In</a>
            </p>

          </form>

        </div>
      </div>
    </div>
  </div>
</section>
<script>
let locationIsValid = false;

/* Password toggle */
const passwordField = document.getElementById("password");
const togglePassword = document.getElementById("togglePassword");

togglePassword.onclick = () => {
  const show = passwordField.type === "password";
  passwordField.type = show ? "text" : "password";
  togglePassword.innerHTML = show
    ? '<i class="bi bi-eye-slash-fill"></i>'
    : '<i class="bi bi-eye-fill"></i>';
};

/* Location autocomplete */
const locationInput = document.getElementById('location-input');
const locationList  = document.getElementById('location-list');
const errorBox      = document.getElementById('location-error');

locationInput.addEventListener('input', () => {
  locationIsValid = false;
  errorBox.classList.add('d-none');

  const q = locationInput.value.trim();

  if (q.length < 2) {
    locationList.classList.add('d-none');
    locationList.innerHTML = '';
    return;
  }

  fetch('fetch_locations.php', {
    method: 'POST',
    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
    body: 'q=' + encodeURIComponent(q)
  })
  .then(res => res.json())
  .then(data => {
    locationList.innerHTML = '';

    if (!data.length) {
      locationList.classList.add('d-none');
      return;
    }

    data.forEach(loc => {
      const btn = document.createElement('button');
      btn.type = 'button';
      btn.className = 'list-group-item list-group-item-action';
      btn.textContent = loc;

      btn.onclick = () => {
        locationInput.value = loc;
        locationIsValid = true;
        locationList.classList.add('d-none');
        errorBox.classList.add('d-none');
        fetchBranch(loc);
      };

      locationList.appendChild(btn);
    });

    locationList.classList.remove('d-none');
  });
});

/* Hide dropdown */
document.addEventListener('click', e => {
  if (!e.target.closest('.position-relative')) {
    locationList.classList.add('d-none');
  }
});

/* Block submit if location invalid */
document.getElementById('signup-form').addEventListener('submit', e => {
  if (!locationIsValid) {
    e.preventDefault();
    errorBox.classList.remove('d-none');
    locationInput.focus();
  }
});

/* Branch auto-fill */
function fetchBranch(location) {
  const xhr = new XMLHttpRequest();
  xhr.open('POST', 'fetch_branches.php', true);
  xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
  xhr.onload = () => {
    if (xhr.status === 200) {
      const data = JSON.parse(xhr.responseText);
      document.getElementById('branch').value = data.length ? data[0].branch : '';
    }
  };
  xhr.send('location=' + encodeURIComponent(location));
}
</script>
</body>
</html>