<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<title>MER Admin Portal</title>

<!-- Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<!-- Bootstrap -->
<link rel="stylesheet" href="assets/css/bootstrap.min.css">

<style>
body {
    font-family: 'Poppins', sans-serif;
    background: #f7f7f7;
    margin: 0;
}

/* ---------- Modern Page Loader ---------- */
.page-loader {
    position: fixed;
    inset: 0;
    background: #ffffff;
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 99999;
    transition: opacity .4s ease;
}

.loader-container img {
    width: 150px;
    animation: blink 1.4s infinite ease-in-out;
}

@keyframes blink {
    0% { opacity: 1; transform: scale(1); }
    50% { opacity: .3; transform: scale(0.96); }
    100% { opacity: 1; transform: scale(1); }
}

/* ---------- Section Title ---------- */
.section-title {
    font-weight: 600;
    font-size: 26px;
    color: #111;
}

/* ---------- Cool glass card ---------- */
.pricing-item {
    background: rgba(255, 255, 255, 0.85);
    backdrop-filter: blur(10px);
    border-radius: 18px;
    padding: 25px;
    margin-top: 25px;
    box-shadow: 0px 8px 20px rgba(0, 0, 0, 0.12);
    transition: all 0.25s ease;
}

.pricing-item:hover {
    transform: translateY(-3px);
    box-shadow: 0px 12px 28px rgba(0,0,0,0.16);
}

/* ---------- Title inside card ---------- */
.pricing-header h3 {
    font-size: 18px;
    font-weight: 600;
    color: #444;
    margin-bottom: 15px;
    text-align: center;
}

/* ---------- Value text ---------- */
.price {
    font-size: 20px;
    font-weight: 600;
    color: #222;
    display: block;
    text-align: center;
    line-height: 1.4;
}

/* ---------- Buttons ---------- */
.main-button {
    display: inline-block;
    background: #111;
    color: white !important;
    padding: 10px 22px;
    border-radius: 50px;
    font-size: 14px;
    font-weight: 500;
    text-decoration: none;
    transition: .3s ease;
    border: none;
}

.main-button:hover {
    background: #444;
}

/* ---------- Center Text ---------- */
.center-text {
    text-align: center;
    padding-bottom: 12px;
}

#content {
    display: none;
}
</style>

</head>

<body id="content">

<!-- ---------- Page Loader ---------- -->
<div class="page-loader">
    <div class="loader-container">
        <img src="omnislogo.png" class="logo">
    </div>
</div>

<script>
window.onload = function() {
    setTimeout(function() {
        document.getElementById('content').style.display = 'block';
        document.querySelector('.page-loader').style.opacity = '0';
        setTimeout(()=> document.querySelector('.page-loader').style.display='none',400);
    }, 600);
};
</script>


<!-- ---------- MAIN SECTION ---------- -->
<section class="section colored" style="padding-top: 40px;">

<div class="container">

    <div class="row">
        <div class="col-lg-12 text-center">
            <h2 class="section-title">Glance Stats:</h2>
        </div>
    </div>

    <div class="row justify-content-center">
        <div class="col-lg-6 center-text">

CURRENT DATE:  
<strong>
<?php
date_default_timezone_set('Africa/Kampala');
echo date("Y-m-d");
?>
</strong>

<br>

<span style="font-size:13px;">
REPORT DURATION:
<strong><?php echo $_POST['date1']; ?> TO <?php echo $_POST['date2']; ?></strong>
</span>

<p style="letter-spacing:3px;">••••••••••••••••••</p>
        </div>
    </div>

    <form action="accountshome.php" method="post" class="text-center">
        <button type="submit" class="main-button">Back</button>
    </form>


    <div class="row">

        <!-- ---------- SALES ONLINE CARD ---------- -->
        <div class="col-lg-4 col-md-6 col-sm-12">
            <div class="pricing-item">

                <div class="pricing-header">
                    <h3>(ALL SALES | ONLINE)</h3>
                </div>

                <div class="pricing-body">

                    <span class="price">
                    DISPATCHED TOTAL:<br>
                    <?php
                    include('conn.php');
                    $customer = $_POST['customer'];
                    $name = $_POST['name'];
                    $phone = $_POST['phone'];
                    $date1 = $_POST['date1'];
                    $date2 = $_POST['date2'];

                    $total_sum = 0;

                    $queries = [
                        "SELECT SUM(qty * price) AS total_sum FROM breakfastorders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'",
                        "SELECT SUM((qty * price) + addon1price) AS total_sum FROM manakishorders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'",
                        "SELECT SUM(qty * price) AS total_sum FROM coldorders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'",
                        "SELECT SUM(qty * price) AS total_sum FROM hotorders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'",
                        "SELECT SUM(qty * price) AS total_sum FROM saladorders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'",
                        "SELECT SUM((drinkprice * drinkqty) + (teaprice * teaqty) + (iceteaprice * iceteaqty) +
                        (icecoffeeprice * icecoffeeqty) + (coffeeprice * coffeeqty) + (lemonadeprice * lemonadeqty) +
                        (smoothieprice * smoothieqty) + (thickshakeprice * thickshakeqty) +
                        (boosterprice * boosterqty) + (signatureprice * signatureqty) + (coladaprice * coladaqty) +
                        (slushyprice * slushyqty) + (softprice * softqty) + (milkshakeprice * milkshakeqty)
                        ) AS total_sum FROM drinksorders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'",
                        "SELECT SUM((qty * price) + addon1price) AS total_sum FROM seaorders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'",
                        "SELECT SUM((qty * price) + addon1price + addon2price + addon3price + addon4price + addon5price + addon6price + addon7price + addon8price) AS total_sum FROM orders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'",
                        "SELECT SUM((qty * price) + addon1price + addon2price + addon3price + addon4price + addon5price + addon6price) AS total_sum FROM pizzaorders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'",
                        "SELECT SUM((qty * price) + addon1price + addon2price + addon3price) AS total_sum FROM pastaorders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'",
                        "SELECT SUM((qty * price) + addon1price + addon2price + addon3price) AS total_sum FROM specialorders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'",
                        "SELECT SUM((qty * price) + addon1price) AS total_sum FROM promoorders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'",
                        "SELECT SUM((qty * price) + addon1price + addon2price + addon3price + addon4price + addon5price + addon6price + addon7price + addon8price + addon9price + addon10price) AS total_sum FROM grillorders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'",
                        "SELECT SUM((qty * price) + addon1price + addon2price + addon3price + addon4price + addon5price + addon6price + addon7price + addon8price + addon9price + addon10price) AS total_sum FROM mainorders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'",
                        "SELECT SUM((qty * price) + addon1price + addon2price + addon3price + addon4price + addon5price + addon6price + addon7price + addon8price + addon9price) AS total_sum FROM burgerorders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'",
                        "SELECT SUM((qty * price) + addon1price + addon2price + addon3price + addon4price + addon5price + addon6price + addon7price + addon8price + addon9price) AS total_sum FROM sandwichorders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'",
                        "SELECT SUM((qty * price) + addon1price + addon2price + addon3price + addon4price + addon5price + addon6price + addon7price + addon8price + addon9price + addon10price) AS total_sum FROM curryorders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'",
                        "SELECT SUM(qty * price) AS total_sum FROM dessertorders WHERE date BETWEEN '$date1' AND '$date2' AND status='sent'"
                    ];

                    foreach ($queries as $query) {
                        $result = mysqli_query($conn, $query);
                        $row = mysqli_fetch_array($result);
                        $total_sum += $row['total_sum'];
                    }

                    echo number_format($total_sum, 0);
                    ?>
                    </span>

                    <hr>

                    <span class="price">
                    PENDING TOTAL:<br>
                    <?php
                    include('conn.php');
                    $date1 = $_POST['date1'];
                    $date2 = $_POST['date2'];
                    $customer = $_POST['customer'];
                    $name = $_POST['name'];
                    $phone = $_POST['phone'];

                    $total_sum = 0;

                    $queries = [
                        "SELECT SUM(qty*price) AS total_sum FROM breakfastorders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'",
                        "SELECT SUM((qty*price) + addon1price) AS total_sum FROM manakishorders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'",
                        "SELECT SUM(qty*price) AS total_sum FROM coldorders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'",
                        "SELECT SUM(qty*price) AS total_sum FROM hotorders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'",
                        "SELECT SUM(qty*price) AS total_sum FROM saladorders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'",
                        "SELECT SUM(
                        (drinkprice*drinkqty) + (teaprice*teaqty) + (iceteaprice*iceteaqty) +
                        (icecoffeeprice*icecoffeeqty) + (coffeeprice*coffeeqty) + (lemonadeprice*lemonadeqty) +
                        (smoothieprice*smoothieqty) + (thickshakeprice*thickshakeqty) +
                        (boosterprice*boosterqty) + (signatureprice*signatureqty) + (coladaprice*coladaqty) +
                        (slushyprice*slushyqty) + (softprice*softqty) + (milkshakeprice*milkshakeqty)
                        ) AS total_sum FROM drinksorders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'",
                        "SELECT SUM((qty*price)+addon1price) AS total_sum FROM seaorders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'",
                        "SELECT SUM((qty*price)+addon1price+addon2price+addon3price+addon4price+addon5price+addon6price+addon7price+addon8price) AS total_sum FROM orders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'",
                        "SELECT SUM((qty*price)+addon1price+addon2price+addon3price+addon4price+addon5price+addon6price) AS total_sum FROM pizzaorders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'",
                        "SELECT SUM((qty*price)+addon1price+addon2price+addon3price) AS total_sum FROM pastaorders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'",
                        "SELECT SUM((qty*price)+addon1price+addon2price+addon3price) AS total_sum FROM specialorders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'",
                        "SELECT SUM((qty*price)+addon1price) AS total_sum FROM promoorders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'",
                        "SELECT SUM((qty*price)+addon1price+addon2price+addon3price+addon4price+addon5price+addon6price+addon7price+addon8price+addon9price+addon10price) AS total_sum FROM grillorders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'",
                        "SELECT SUM((qty*price)+addon1price+addon2price+addon3price+addon4price+addon5price+addon6price+addon7price+addon8price+addon9price+addon10price) AS total_sum FROM mainorders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'",
                        "SELECT SUM((qty*price)+addon1price+addon2price+addon3price+addon4price+addon5price+addon6price+addon7price+addon8price+addon9price) AS total_sum FROM burgerorders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'",
                        "SELECT SUM((qty*price)+addon1price+addon2price+addon3price+addon4price+addon5price+addon6price+addon7price+addon8price+addon9price) AS total_sum FROM sandwichorders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'",
                        "SELECT SUM((qty*price)+addon1price+addon2price+addon3price+addon4price+addon5price+addon6price+addon7price+addon8price+addon9price+addon10price) AS total_sum FROM curryorders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'",
                        "SELECT SUM(qty*price) AS total_sum FROM dessertorders WHERE date BETWEEN '$date1' AND '$date2' AND status='pending'"
                    ];

                    foreach ($queries as $query) {
                        $result = mysqli_query($conn, $query);
                        $row = mysqli_fetch_array($result);
                        $total_sum += $row['total_sum'];
                    }

                    echo number_format($total_sum, 0);
                    ?>
                    </span>

                </div>

                <div class="pricing-footer text-center" style="margin-top: 18px;">
                    <a href="onlineordershome2.php" class="main-button">View Data</a>
                </div>

            </div>
        </div>

    </div> <!-- row end -->
</div>
</section>

<!-- Scripts -->
<script src="assets/js/jquery-2.1.0.min.js"></script>
<script src="assets/js/popper.js"></script>
<script src="assets/js/bootstrap.min.js"></script>

</body>
</html>