<?php

// Set session cookie parameters to last for one day
session_set_cookie_params([
    'lifetime' => 86400, // Cookie will last for one day
    'path' => '/',
    'domain' => 'omnisservicehub.ug', // Use the domain without 'https://'
    'secure' => true, // Set to true if using HTTPS
    'httponly' => true,
    'samesite' => 'Lax', // Adjust according to your needs
]);

// Start the session
session_start();

// Check if the session variable 'name' is set
if (!isset($_SESSION['name'])) {
    // Redirect to login page if not set
    header("Location: index.html");
    exit();
}

// Retrieve the user's name from the session
$userName = $_SESSION['name'];
?>






<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <link href="https://fonts.googleapis.com/css?family=Raleway:100,300,400,500,700,900" rel="stylesheet">
    <title>Omnis Business Hub - Admin Hub</title>
    <!-- Additional CSS Files -->
    <link rel="stylesheet" type="text/css" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="assets/css/font-awesome.css">
    <link rel="stylesheet" href="assets/css/templatemo-softy-pinko.css">
    </head>
    <body>
    
    <!-- ***** Preloader Start ***** -->
    <div id="preloader">
        <div class="jumper">
            <div></div>
            <div></div>
            <div></div>
        </div>
    </div>  
    <!-- ***** Preloader End ***** -->

    <!-- ***** Contact Us Start ***** -->
    <section  style="display:;" class="section colored" id="contact-us">

    <!-- ***** Header Area Start ***** -->
    <header style="display:;" class="header-area header-sticky">
        <div class="container">
            <div class="row">
                <div class="col-12">
 <div style="overflow-x: auto; display: block; white-space: nowrap; background-color:#ffffffb6; border-radius:24px; padding:10px 20px;">
  <div style="display: flex; flex-wrap: wrap;">
    <div style="flex: 1;">
    
      <a style="text-decoration: none; color: #007bff; padding: 4px 8px; border-radius: 8px; border: 2px solid #007bff; transition: background-color 0.3s ease, color 0.3s ease; margin: 2px; display: inline-block; touch-action: manipulation; font-size: 12px; font-weight: bold;" href="triagehome.php">Triage Entries</a>
      <a style="text-decoration: none; color: #007bff; padding: 4px 8px; border-radius: 8px; border: 2px solid #007bff; transition: background-color 0.3s ease, color 0.3s ease; margin: 2px; display: inline-block; touch-action: manipulation; font-size: 12px; font-weight: bold;" href="triageviewhome.php">Triage Records</a>
  
      <a style="text-decoration: none; color: #007bff; padding: 4px 8px; border-radius: 8px; border: 2px solid #007bff; transition: background-color 0.3s ease, color 0.3s ease; margin: 2px; display: inline-block; touch-action: manipulation; font-size: 12px; font-weight: bold;" href="inpatientsviewhome.php">In-patient Billing</a>
      <a style="text-decoration: none; color: #007bff; padding: 4px 8px; border-radius: 8px; border: 2px solid #007bff; transition: background-color 0.3s ease, color 0.3s ease; margin: 2px; display: inline-block; touch-action: manipulation; font-size: 12px; font-weight: bold;" href="pharmacypresnviewhome.php">Prescriptions</a>
    
  <a style="text-decoration: none; color: #ff0000; padding: 4px 8px; border-radius: 8px; border: 2px solid #ff0000; transition: background-color 0.3s ease, color 0.3s ease; margin: 2px; display: inline-block; touch-action: manipulation; font-size:12px; font-weight:bold;" 
   href="index.html" 
   onclick="destroySession(event)">Close</a>

<script>
  function destroySession(event) {
    event.preventDefault(); // Prevent the default anchor behavior
    // Make an AJAX request to the PHP script to destroy the session
    fetch('endsession.php', {
      method: 'POST',
      credentials: 'same-origin'
    }).then(response => {
      if (response.ok) {
        // Redirect to the index page after session destruction
        window.location.href = 'index.html';
      } else {
        console.error('Failed to destroy session.');
      }
    }).catch(error => {
      console.error('Error destroying session:', error);
    });
  }
</script>     
      
    </div>
  </div>
</div>
                </div>
            </div>
        </div>
    </header>
    <!-- ***** Header Area End ***** -->
    
<hr>
        <div class="container">
            <div class="row">
                <!-- ***** Contact Form Start ***** -->
                <div class="col-lg-8 col-md-6 col-sm-12">
                    <div class="contact-form">
     <div style="overflow-x:auto;  display: block; font-weight:480;  white-space:nowrap;">   
       Hi. <?php echo htmlspecialchars($userName); ?>
     
     
     
 <table style="font-size: 18px; width:1100px; padding-left:20px;">

    <span style="color:purple; padding-left:20px;">Active Patient list- <?php
   // Set the timezone to Kampala
    date_default_timezone_set('Africa/Kampala');
    
            $class = $_POST['class'];
            $date1 = $_POST['date1'];
            $date2 = $_POST['date2'];
            $project = $_POST['project'];
         include('conn.php');

            $sql = "SELECT count(*) FROM billingconsult WHERE tag='outpatient' and DATE(date) = CURDATE()";

            if ($result = mysqli_query($conn, $sql)) {
                if (mysqli_num_rows($result) > 0) {
                    while ($row = mysqli_fetch_array($result)) {
                        echo $row['count(*)'];
                    }
                    mysqli_free_result($result);
                } else {
                    echo "No records matching your query were found.";
                }
            } else {
                echo "ERROR: Could not execute $sql. " . mysqli_error($conn);
            }

            mysqli_close($conn);
            ?>
.</span>
    <hr style="border-bottom: dotted 2px blue;">
 
  <tbody style="padding-left:20px;">
        <p style="font-size:12px;">
            <?php
  // Set the timezone to Kampala
    date_default_timezone_set('Africa/Kampala');

 
           include('conn.php');
            $date1 = $_POST['date1'];
            $date2 = $_POST['date2'];
            $status = $_POST['status'];
            
            // Variable to track row color
            $white = true;

$query = mysqli_query($conn, "SELECT * FROM `billingconsult` WHERE tag='outpatient' and DATE(date) = CURDATE() ORDER BY time desc");
            while ($row = mysqli_fetch_array($query)) {
                // Use a light white color
                $rowColor = $white ? '#2502022d' : 'white';
                ?>
         
         
    <tr style='background-color:<?php echo $rowColor; ?>; border-radius: 34px;'>
     <td onclick="toggleDetails(event);" style='width:4%; font-size:12px; color: purple;'><?php echo $row['consult11']; ?></td>
 
    <td onclick="toggleDetails(event);" style='width: 8%; padding:5px; font-size:12px; text-transform: uppercase; cursor: pointer;'><?php echo $row['pname']; ?></td>
 
    <td onclick="toggleDetails(event);" style='width: 8%; font-size:12px; color:purple;'><?php echo $row['time']; ?></td>
    
   <td onclick="toggleDetails(event);" style='width: 12%; font-size:12px; text-transform:uppercase; font-weight:; padding:5px;'><?php echo $row['doctor']; ?></td>



    <td colspan="7" style='display:;' class="details">
        <table>
            <tr>
    
         
                <td style='width:; border:solid 1px  #fff; font-size:12px; color: purple;'>
        <a style="color: purple; padding:5px;" href="triagehome2.php?id=<?php echo $row['id']; ?>">Enter Triage</a>
                </td>
       
       
            </tr>
        </table>
    </td>
</tr>

            <?php
                // Toggle row color
                $white = !$white;
            }
            ?>
        </p>
    </tbody>
</table>                     
        </div>              
                      
                      
                      
   <form id="contact" action="triage.php" style="display:none;" method="post"   onsubmit="return validateForm()">
    <div class="row">
    <div class="col-lg-6 col-md-12 col-sm-12">
  <span style="font-size:14px;">Select Patient Name:</span>  
       <fieldset>
    <input name="pname" type="search" list="pname" class="form-control"  required autocomplete="off">      	
       <datalist id="pname">
	 <?php
        include "dbConn.php";  // Using database connection file here
         	$date = $_POST['date'];
        $records = mysqli_query($db, "SELECT * from patientdata");  // Use select query here 
        while($data = mysqli_fetch_array($records))
        {
   echo "<option value='". $data['pname'] ."'>";  // displaying data in option menu
        }	
    ?>   
</datalist>
   </fieldset>
   </div>
    <div class="col-lg-6 col-md-12 col-sm-12">                    
        <fieldset>
	<span style="font-size:12px;">Date:</span>
     <input name="date" type="date" class="form-control"   value="<?php echo $_POST['date'];; ?>" required readonly>
          </fieldset>   
  </div>
   <div class="col-lg-6 col-md-12 col-sm-12"> 
  <fieldset>
	<span style="font-size:12px;">Time In:</span>
     <input name="time" type="text" class="form-control"   value="<?php
date_default_timezone_set('Africa/Kampala');
echo date("H:i:s");
?>"  required readonly>
          </fieldset>      
 </div>     
    <div class="col-lg-6 col-md-12 col-sm-12">
             <fieldset>
	<span style="font-size:12px;">Blood Pressure:</span>
     <input name="bp" type="text" class="form-control" required>
          </fieldset>    
   </div>
    <div class="col-lg-6 col-md-12 col-sm-12"> 
      <fieldset>
	<span style="font-size:12px;">Temperature:</span>
     <input name="temperature" type="text" class="form-control"  required>
          </fieldset>    
 </div> 
    <div class="col-lg-6 col-md-12 col-sm-12">
                    <fieldset>
	<span style="font-size:12px;">PR:</span>
     <input name="pr" type="text" class="form-control" required>
          </fieldset>     
          </div>
    <div class="col-lg-6 col-md-12 col-sm-12">        
             <fieldset>
	<span style="font-size:12px;">SPo2:</span>
     <input name="spo2" type="text" class="form-control" required>
          </fieldset>
     </div>
 
 
    <div class="col-lg-6 col-md-12 col-sm-12">
                 <fieldset>
	<span style="font-size:12px;">Height in Centimetres:</span>
     <input name="height" type="text" class="form-control" required>
          </fieldset> 
 </div>
   <div class="col-lg-6 col-md-12 col-sm-12">
              <fieldset>
	<span style="font-size:12px;">Weight in Kilograms:</span>
     <input name="weight" type="text" class="form-control" required>
          </fieldset>     
  </div>

 
 
 
 
    <div class="col-lg-6 col-md-12 col-sm-12" style="display:;">
 <fieldset>
     BMI:                 
      <input type="button" value="GET BMI" style="font-size:10px; background-color:#0a739a; border:solid thin whit; border-radius:34px; color:white;" onclick="calcSum()">
 <input name="bmi"  type="text" class="form-control"  id="total"  required>
  <script>
function calcSum() {
let num1 = document.getElementsByName("weight")[0].value;
let num2 = document.getElementsByName("height")[0].value;
let num3 = document.getElementsByName("height")[0].value;

let sum =  (Number(num1) / Number(num2) / Number(num3)) * 10000;
document.getElementsByName("bmi")[0].value = sum;
}
</script>
    </fieldset>
    </div>
  </div>
  <div class="row">
    <div class="col-lg-6 col-md-12 col-sm-12">
        <fieldset>
	<span style="font-size:12px;">Nurse's Notes(presenting & plan):</span>
     <textarea name="notes" type="text" class="form-control"  rows="4" cols="50"></textarea>
          </fieldset>        
       </div>
       </div>
       
    <div class="row">
    <div class="col-lg-6 col-md-12 col-sm-12">  	   
            <fieldset>
 <button type="submit" id="form-submit" class="main-button">Submit</button>
 <script>
function validateForm() {
    const bp = document.getElementsByName("bp")[0].value;
    const bpPattern = /^\d{1,3}\/\d{1,3}$/; // Regular expression for BP format
    if (!bpPattern.test(bp)) {
        alert("Please enter Blood Pressure in the format: 119/72");
        return false; // Prevent form submission
    }
    return true; // Allow form submission
}
</script>

          </fieldset>
              </div>
              </div>
              </div>
              </div>
            </form>
            </div>
            </div>
 <!-- ***** Contact Form End ***** -->
            </div>
        </div>
    </section>
    <!-- ***** Contact Us End ***** -->

    <!-- ***** Footer Start ***** -->
    <footer>
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <p class="copyright">Copyright &copy; OMNIS BUSINESS HUB - POWERED BY: OMNIS SERVICE HUB</p>
                </div>
            </div>
        </div>
    </footer>
    
    <!-- jQuery -->
    <script src="assets/js/jquery-2.1.0.min.js"></script>
    <!-- Bootstrap -->
    <script src="assets/js/popper.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <!-- Plugins -->
    <script src="assets/js/scrollreveal.min.js"></script>
    <script src="assets/js/waypoints.min.js"></script>
    <script src="assets/js/jquery.counterup.min.js"></script>
    <script src="assets/js/imgfix.min.js"></script> 
    <!-- Global Init -->
    <script src="assets/js/custom.js"></script>
  </body>
</html>